﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class CoreConfiguration : ConfigurationElement
{
    public float CameraZPosition { get; private set; }
    public int CityBoxFillMargin { get; private set; }
    public bool DrawRoadModels { get; private set; }

    public CoreConfiguration() : base("Core")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            CameraZPosition = Convert.ToSingle(configElem.Element("CameraZPosition").Value);
            CityBoxFillMargin = Convert.ToInt32(configElem.Element("CityBoxFillMargin").Value);
            DrawRoadModels = Convert.ToBoolean(configElem.Element("DrawRoadModels").Value);
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing core configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
